/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanRGBInterface;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;

public class PlanImageRGB
extends PlanImage
implements PlanRGBInterface {
    protected int[] pixelsRGB;
    protected int[] pixelsZoomRGB;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    protected boolean twoColors;
    protected int[] RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
    protected int[] RGBControl;
    protected int[] pi = new int[3];
    protected String[] labels = new String[3];
    protected String labelRed;
    protected String labelGreen;
    protected String labelBlue;
    protected PlanImage planRed;
    protected PlanImage planGreen;
    protected PlanImage planBlue;
    protected PlanImage pRef;
    protected boolean flagRed;
    protected boolean flagGreen;
    protected boolean flagBlue;
    protected boolean diff;
    private boolean mustResample = false;
    private double[] histRed = new double[256];
    private double[] histGreen = new double[256];
    private double[] histBlue = new double[256];
    private boolean postAJDone = false;

    protected PlanImageRGB(Aladin aladin) {
        super(aladin);
        this.type = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanImageRGB(Aladin aladin, PlanImage r, PlanImage g, PlanImage b, PlanImage ref, String label, boolean d) {
        super(aladin);
        this.mustResample = true;
        this.type = 2;
        this.isOldPlan = false;
        this.setPixMode(1);
        if (!(r != null && !r.isTransparent() || g != null && !g.isTransparent() || g != null && !g.isTransparent())) {
            this.setPixMode(0);
        }
        this.planRed = r;
        this.planGreen = g;
        this.planBlue = b;
        this.flagRed = this.planRed != null;
        this.flagGreen = this.planGreen != null;
        this.flagBlue = this.planBlue != null;
        double x = Double.MAX_VALUE;
        if (ref == null) {
            if (!(Projection.isOk(r.projd) && Projection.isOk(r.projd) && Projection.isOk(r.projd))) {
                ref = r != null ? r : (g != null ? g : b);
            } else {
                if (r != null && Math.abs(r.projd.c.incA) < x) {
                    ref = r;
                    x = Math.abs(r.projd.c.incA);
                }
                if (g != null && Math.abs(g.projd.c.incA) < x) {
                    ref = g;
                    x = Math.abs(g.projd.c.incA);
                }
                if (b != null && Math.abs(b.projd.c.incA) < x) {
                    ref = b;
                    x = Math.abs(b.projd.c.incA);
                }
            }
        }
        this.pRef = ref;
        this.diff = d;
        this.init(label, this.pRef);
        PlanImageRGB planImageRGB = this;
        synchronized (planImageRGB) {
            this.runme = new Thread((Runnable)this, "AladinBuildRGB");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected PlanImageRGB(Aladin aladin, String file, URL u, MyInputStream inImg, ResourceNode imgNode) {
        this(aladin, file, u, inImg);
        this.imgNode = imgNode;
    }

    protected PlanImageRGB(Aladin aladin, String file, URL u, MyInputStream inImg) {
        super(aladin, file, inImg);
        if (u != null) {
            this.u = u;
        }
        this.type = 2;
        this.setPixMode(1);
        this.active = true;
        this.flagBlue = true;
        this.flagGreen = true;
        this.flagRed = true;
        this.initCMControl();
        this.labels[0] = "red";
        this.labels[1] = "green";
        this.labels[2] = "blue";
        this.flagOk = false;
    }

    protected PlanImageRGB(Aladin aladin, MyInputStream inImg, int orig, URL u, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        super(aladin, inImg, orig, u, label, objet, param, from, fmt, res, o, imgNode);
        this.type = 2;
        this.active = true;
        this.flagBlue = true;
        this.flagGreen = true;
        this.flagRed = true;
        this.initCMControl();
        this.labels[0] = "red";
        this.labels[1] = "green";
        this.labels[2] = "blue";
    }

    protected void initCMControl() {
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
    }

    protected PlanImageRGB(Aladin aladin, PlanImage p) {
        super(aladin, p);
        this.type = 2;
    }

    @Override
    public int[] getPixelsRGB() {
        return this.pixelsRGB;
    }

    @Override
    public int[] getPixelsZoomRGB() {
        return this.pixelsZoomRGB;
    }

    @Override
    protected void copy(Plan p1) {
        super.copy(p1);
        if (!(p1 instanceof PlanImageRGB)) {
            return;
        }
        PlanImageRGB p = (PlanImageRGB)p1;
        p.pixelsRGB = this.getPixelsRGB();
        p.red = this.red;
        p.green = this.green;
        p.blue = this.blue;
        p.twoColors = this.twoColors;
        p.RGBControl = new int[this.RGBCONTROL.length];
        System.arraycopy(this.RGBControl, 0, p.RGBControl, 0, this.RGBControl.length);
        p.pi = new int[this.pi.length];
        System.arraycopy(this.pi, 0, p.pi, 0, this.pi.length);
        p.planRed = this.planRed;
        p.planGreen = this.planGreen;
        p.planBlue = this.planBlue;
        p.labels = this.labels;
        p.flagRed = this.flagRed;
        p.flagGreen = this.flagGreen;
        p.flagBlue = this.flagBlue;
        p.diff = this.diff;
        p.mustResample = this.mustResample;
        p.cm = this.cm;
    }

    @Override
    protected boolean crop(double x, double y, double w, double h, boolean repaint) {
        int test = 0;
        if (x <= 0.0) {
            w += x;
            x = 0.0;
            ++test;
        }
        if (y <= 0.0) {
            h += y;
            y = 0.0;
            ++test;
        }
        if (x + w >= (double)this.width) {
            w = (double)this.width - x;
            ++test;
        }
        if (y + h >= (double)this.height) {
            h = (double)this.height - y;
            ++test;
        }
        if (test == 4) {
            return false;
        }
        int[] npixelsRGB = new int[(int)(w * h)];
        int j = 0;
        while ((double)j < h) {
            int srcPos = (int)((y + (double)j) * (double)this.width + x);
            int destPos = (int)((double)j * w);
            System.arraycopy(this.pixelsRGB, srcPos, npixelsRGB, destPos, (int)w);
            ++j;
        }
        this.pixelsRGB = npixelsRGB;
        this.blue = null;
        this.green = null;
        this.red = null;
        this.crop1(x, y, w, h, repaint);
        return true;
    }

    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int mode;
        boolean isARGB = (dis.getType() & 0x400000000L) != 0L;
        Aladin.trace(2, "Loading " + (isARGB ? "A" : "") + "RGB FITS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.setPixMode(isARGB ? 0 : 1);
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        if (this.bitpix == 0) {
            this.aladin.command.printConsole("!!! RGB BITPIX=0 => assuming BITPIX=8 !\n");
            this.bitpix = 8;
        }
        if (this.bitpix != 8 && !isARGB) {
            this.aladin.command.printConsole("!! RGB BITPIX!=8 => autocutting each color component !\n");
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        if (this.naxis1 <= 0) {
            return false;
        }
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        if (this.naxis2 <= 0) {
            return false;
        }
        int naxis3 = this.headerFits.getIntFromHeader("NAXIS3");
        if (naxis3 <= 0) {
            return false;
        }
        if (naxis3 == 3) {
            mode = 0;
        } else if (this.naxis2 == 3) {
            mode = 1;
            this.width = this.naxis1;
            this.height = naxis3;
        } else if (this.naxis1 == 3) {
            mode = 2;
            this.width = this.naxis2;
            this.height = naxis3;
        } else {
            throw new Exception("Unsupported RGB FITS image (no NAXISn=3 keywords");
        }
        this.npix = Math.abs(this.bitpix) / 8;
        int taille = this.width * this.height * 3;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + naxis3 + " BITPIX=" + this.bitpix + " => size=" + taille);
        Date d = new Date();
        this.video = 0;
        this.red = new byte[this.width * this.height];
        this.green = new byte[this.width * this.height];
        this.blue = new byte[this.width * this.height];
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Allocating (" + taille + "b) in " + temps + " ms");
        if (isARGB) {
            byte[] buf = new byte[this.width * 4];
            int offset = 0;
            int i = 0;
            while (offset < this.width * this.height * 4) {
                dis.readFully(buf);
                this.setPourcent((double)((offset += buf.length) / (this.width * this.height * 4)) * 0.8);
                int j = 0;
                while (j < buf.length) {
                    int mod = i % 4;
                    int pos = i / 4;
                    switch (mod) {
                        case 1: {
                            this.red[pos] = buf[j];
                            break;
                        }
                        case 2: {
                            this.green[pos] = buf[j];
                            break;
                        }
                        case 3: {
                            this.blue[pos] = buf[j];
                        }
                    }
                    ++j;
                    ++i;
                }
            }
            buf = null;
        } else if (mode == 0) {
            for (int i = 0; i < 3; ++i) {
                byte[] buf = i == 0 ? this.red : (i == 1 ? this.green : this.blue);
                this.readColor(buf, dis, this.width, this.height, this.bitpix);
                this.setPourcent(this.pourcent + 33.0);
            }
        } else if (mode == 2) {
            String e = "RGB FITS image width suspicious pixel order (3x width x height). Load anyway";
            this.aladin.warning(e);
            this.aladin.console.printError("!!! " + e);
            this.readColorALaThomas(this.red, this.green, this.blue, dis, this.width, this.height, this.bitpix);
        } else if (mode == 1) {
            throw new Exception("Unsupported RGB FITS format (width x 3 x height !).");
        }
        d1 = new Date();
        temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Reading in " + temps + " ms");
        PlanImageRGB.invImageLine(this.width, this.height, this.red);
        PlanImageRGB.invImageLine(this.width, this.height, this.green);
        PlanImageRGB.invImageLine(this.width, this.height, this.blue);
        this.createImgRGB();
        this.cm = ColorModel.getRGBdefault();
        this.setPourcent(99.0);
        return true;
    }

    private void readColor(byte[] pOut, MyInputStream dis, int width, int height, int bitpix) throws Exception {
        if (bitpix == 8) {
            dis.readFully(pOut);
        } else {
            int taille = width * height * Math.abs(bitpix) / 8;
            byte[] pIn = new byte[taille];
            dis.readFully(pIn);
            this.getPix8Bits(pOut, pIn, bitpix, width, height, 0.0, 0.0, true, 0, 0, 0);
            pIn = null;
        }
    }

    private void readColorALaThomas(byte[] red, byte[] green, byte[] blue, MyInputStream dis, int width, int height, int bitpix) throws Exception {
        int npix = Math.abs(bitpix) / 8;
        int taille = width * height;
        byte[] pIn = new byte[3 * taille * npix];
        dis.readFully(pIn);
        byte[] r = bitpix == 8 ? red : new byte[taille * npix];
        byte[] g = bitpix == 8 ? green : new byte[taille * npix];
        byte[] b = bitpix == 8 ? blue : new byte[taille * npix];
        boolean i = false;
        for (int from = 0; from < pIn.length; from += npix) {
            int z = from % 3;
            byte[] out = z == 0 ? r : (z == 1 ? g : b);
            int to = from / 3;
            System.arraycopy(pIn, from, out, to, npix);
        }
        if (bitpix != 8) {
            this.getPix8Bits(red, r, bitpix, width, height, 0.0, 0.0, true, 0, 0, 0);
            this.getPix8Bits(green, g, bitpix, width, height, 0.0, 0.0, true, 0, 0, 0);
            this.getPix8Bits(blue, b, bitpix, width, height, 0.0, 0.0, true, 0, 0, 0);
        }
    }

    @Override
    public void calculPixelsZoomRGB() {
        this.pixelsZoomRGB = PlanImageRGB.calculPixelsZoomRGB1(this.aladin, this.pixelsZoomRGB, this.pixelsRGB, this.width, this.height);
    }

    public static int[] calculPixelsZoomRGB1(Aladin aladin, int[] pixelsZoomRGB, int[] pixelsRGB, int width, int height) {
        int w = aladin.calque.zoom.zoomView.getWidth();
        int h = aladin.calque.zoom.zoomView.getHeight();
        if (pixelsZoomRGB == null || pixelsZoomRGB.length != w * h) {
            pixelsZoomRGB = new int[w * h];
        }
        double fct = Math.max((double)width / (double)w, (double)height / (double)h);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int xi = (int)((double)x * fct + 0.5);
                int yi = (int)((double)y * fct + 0.5);
                pixelsZoomRGB[y * w + x] = xi >= width || yi >= height ? 0 : pixelsRGB[yi * width + xi];
            }
        }
        return pixelsZoomRGB;
    }

    @Override
    synchronized void changeImgID() {
        super.changeImgID();
        this.pixelsZoomRGB = null;
    }

    protected byte[] getGreyPixels() {
        byte[] pix = new byte[this.pixelsRGB.length];
        for (int i = 0; i < this.pixelsRGB.length; ++i) {
            pix[i] = (byte)PlanImageRGB.getGreyPixel(this.pixelsRGB[i]);
        }
        return pix;
    }

    public static double getGreyPixel(int pixRGB) {
        int red = PlanImageRGB.getPixRGB(pixRGB, 0);
        int green = PlanImageRGB.getPixRGB(pixRGB, 1);
        int blue = PlanImageRGB.getPixRGB(pixRGB, 2);
        return (double)red * 0.299 + (double)green * 0.587 + (double)blue * 0.114;
    }

    @Override
    protected double getPixelInDouble(int x, int y) {
        int pixelRGB = this.pixelsRGB[(this.height - y - 1) * this.width + x];
        return PlanImageRGB.getGreyPixel(pixelRGB);
    }

    @Override
    protected String getSizeInfo() {
        return this.width + "x" + this.height + "x3 pixels";
    }

    protected void createRGB() {
        if (this.pixelsRGB == null) {
            return;
        }
        if (this.red != null && this.red.length == this.pixelsRGB.length) {
            return;
        }
        int size = this.pixelsRGB.length;
        this.red = new byte[size];
        this.green = new byte[size];
        this.blue = new byte[size];
        for (int i = 0; i < size; ++i) {
            this.red[i] = (byte)(this.pixelsRGB[i] >> 16 & 0xFF);
            this.green[i] = (byte)(this.pixelsRGB[i] >> 8 & 0xFF);
            this.blue[i] = (byte)(this.pixelsRGB[i] & 0xFF);
        }
    }

    protected byte[] getByteRGB() {
        if (this.pixelsRGB == null) {
            return null;
        }
        int size = this.pixelsRGB.length * 3;
        byte[] rgb = new byte[size];
        for (int i = 0; i < size; i += 3) {
            int pix = this.pixelsRGB[i / 3];
            rgb[i] = (byte)(pix >> 16 & 0xFF);
            rgb[i + 1] = (byte)(pix >> 8 & 0xFF);
            rgb[i + 2] = (byte)(pix & 0xFF);
        }
        return rgb;
    }

    protected void setByteRGB(byte[] rgb) {
        int size = rgb.length;
        this.pixelsRGB = new int[size / 3];
        for (int i = 0; i < size; i += 3) {
            this.pixelsRGB[i / 3] = (rgb[i] & 0xFF) << 16 | (rgb[i + 1] & 0xFF) << 8 | rgb[i + 2] & 0xFF;
        }
    }

    protected byte[] getColor(byte[] c, int color) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = (byte)(0xFF & PlanImageRGB.getPixRGB(this.pixelsRGB, i, color));
        }
        return c;
    }

    protected byte[] getRed() {
        if (this.red == null || this.red.length != this.pixelsRGB.length) {
            this.createRGB();
        }
        return this.red;
    }

    protected byte[] getBlue() {
        if (this.blue == null || this.blue.length != this.pixelsRGB.length) {
            this.createRGB();
        }
        return this.blue;
    }

    protected byte[] getGreen() {
        if (this.green == null || this.green.length != this.pixelsRGB.length) {
            this.createRGB();
        }
        return this.green;
    }

    @Override
    protected double[] getHistArray(int rgb) {
        return rgb == 0 ? this.histRed : (rgb == 1 ? this.histGreen : this.histBlue);
    }

    @Override
    protected byte[] getPixelHist(int rgb) {
        return rgb == 0 ? this.getRed() : (rgb == 1 ? this.getGreen() : this.getBlue());
    }

    @Override
    protected byte[] getBufPixels8() {
        return this.getGreyPixels();
    }

    @Override
    protected boolean Free() {
        if (!super.Free()) {
            return false;
        }
        this.pixelsRGB = null;
        this.blue = null;
        this.green = null;
        this.red = null;
        this.planBlue = null;
        this.planGreen = null;
        this.planRed = null;
        this.flagBlue = false;
        this.flagGreen = false;
        this.flagRed = false;
        this.pi[2] = -1;
        this.pi[1] = -1;
        this.pi[0] = -1;
        return true;
    }

    protected void init(String label, PlanImage p) {
        this.flagOk = false;
        this.askActive = true;
        this.headerFits = null;
        if (Projection.isOk(p.projd)) {
            this.setHasSpecificCalib();
        }
        this.naxis1 = this.width = p.width;
        this.naxis2 = this.height = p.height;
        this.video = 0;
        this.fmt = 6;
        this.transfertFct = 3;
        this.res = 0;
        this.orig = 3;
        this.status = "Re-sampling (at the nearest pixel):";
        this.progress = "computing...";
        this.objet = p.objet;
        this.body = p.body;
        if (label == null) {
            label = "RGB img";
        }
        this.setLabel(label);
        this.co = p.co;
        this.c = p.c;
        this.projd = p.projd.copy();
        this.projD = p.projD == null ? null : (Hashtable)p.projD.clone();
        this.copyright = "Colored composition by Aladin";
        this.pi[0] = this.flagRed ? this.planRed.hashCode() : 0;
        this.pi[1] = this.flagGreen ? this.planGreen.hashCode() : 0;
        this.pi[2] = this.flagBlue ? this.planBlue.hashCode() : 0;
        this.labels[0] = this.planRed != null ? this.planRed.label : "none";
        this.labels[1] = this.planGreen != null ? this.planGreen.label : "none";
        this.labels[2] = this.planBlue != null ? this.planBlue.label : "none";
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.param = "R:" + this.labels[0] + " G:" + this.labels[1] + " B:" + this.labels[2];
    }

    private void setPixRGB(int[] pixelsRGB, int offset, int color, int value) {
        switch (color) {
            case 0: {
                int n = offset;
                pixelsRGB[n] = pixelsRGB[n] & 0xFF00FFFF;
                int n2 = offset;
                pixelsRGB[n2] = pixelsRGB[n2] | 0xFF0000 & value << 16;
                break;
            }
            case 1: {
                int n = offset;
                pixelsRGB[n] = pixelsRGB[n] & 0xFFFF00FF;
                int n3 = offset;
                pixelsRGB[n3] = pixelsRGB[n3] | 0xFF00 & value << 8;
                break;
            }
            case 2: {
                int n = offset;
                pixelsRGB[n] = pixelsRGB[n] & 0xFFFFFF00;
                int n4 = offset;
                pixelsRGB[n4] = pixelsRGB[n4] | 0xFF & value;
            }
        }
    }

    protected static int getPixRGB(int[] pixelsRGB, int offset, int color) {
        return PlanImageRGB.getPixRGB(pixelsRGB[offset], color);
    }

    private static int getPixRGB(int pixelRGB, int color) {
        switch (color) {
            case 0: {
                return 0xFF & pixelRGB >> 16;
            }
            case 1: {
                return 0xFF & pixelRGB >> 8;
            }
        }
        return 0xFF & pixelRGB;
    }

    @Override
    protected boolean waitForPlan() {
        int i;
        if (!this.mustResample) {
            if (!super.waitForPlan()) {
                return false;
            }
            this.calculPixelsZoomRGB();
            return true;
        }
        Aladin.trace(3, "Resampling (R:" + this.labels[0] + ",G:" + this.labels[1] + ",B:" + this.labels[2] + " astro from " + this.pRef.label + ")...");
        int tR = 0;
        int tA = 1;
        int tB = 2;
        PlanImage pA = null;
        PlanImage pB = null;
        if (this.pRef == this.planRed) {
            pA = this.planGreen;
            pB = this.planBlue;
            tR = 0;
            tA = 1;
            tB = 2;
        } else if (this.pRef == this.planGreen) {
            pA = this.planRed;
            pB = this.planBlue;
            tR = 1;
            tA = 0;
            tB = 2;
        } else if (this.pRef == this.planBlue) {
            pA = this.planRed;
            pB = this.planGreen;
            tR = 2;
            tA = 0;
            tB = 1;
        }
        Coord coo = new Coord();
        int x = 0;
        int y = 0;
        int w = this.pRef.width;
        this.pixelsRGB = new int[this.pRef.width * this.pRef.height];
        for (i = 0; i < this.pixelsRGB.length; ++i) {
            this.pixelsRGB[i] = -16777216;
        }
        boolean pAeqRef = true;
        boolean pBeqRef = true;
        if ((pA == null || Projection.isOk(pA.projd)) && (pB == null || Projection.isOk(pB.projd)) && Projection.isOk(this.pRef.projd)) {
            pAeqRef = pA != null && this.pRef.projd.c.TheSame(pA.projd.c);
            pBeqRef = pB != null && this.pRef.projd.c.TheSame(pB.projd.c);
        }
        boolean refRev = this.pRef.video == 1;
        boolean pARev = pA != null && pA.video == 1;
        boolean pBRev = pB != null && pB.video == 1;
        byte[] refCm = this.pRef == null ? null : Util.getTableCM(this.pRef.cm, 2);
        byte[] pACm = pA == null ? null : Util.getTableCM(pA.cm, 2);
        byte[] pBCm = pB == null ? null : Util.getTableCM(pB.cm, 2);
        for (i = 0; i < this.pRef.pixels.length; ++i) {
            this.setPixRGB(this.pixelsRGB, i, tR, refRev ? 255 - refCm[0xFF & this.pRef.pixels[i]] : refCm[0xFF & this.pRef.pixels[i]]);
        }
        if (pAeqRef && pA != null) {
            for (i = 0; i < pA.pixels.length; ++i) {
                this.setPixRGB(this.pixelsRGB, i, tA, pARev ? 255 - pACm[0xFF & pA.pixels[i]] : pACm[0xFF & pA.pixels[i]]);
            }
        }
        if (pBeqRef && pB != null) {
            for (i = 0; i < pB.pixels.length; ++i) {
                this.setPixRGB(this.pixelsRGB, i, tB, pBRev ? 255 - pBCm[0xFF & pB.pixels[i]] : pBCm[0xFF & pB.pixels[i]]);
            }
        }
        if (!pAeqRef || !pBeqRef) {
            for (i = 0; i < this.pRef.pixels.length; ++i) {
                coo.x = i % w;
                coo.y = i / w;
                this.pRef.projd.getCoord(coo);
                if (Double.isNaN(coo.al)) continue;
                if (!pAeqRef && pA != null) {
                    pA.projd.getXY(coo);
                    if (!Double.isNaN(coo.x)) {
                        x = (int)Math.round(coo.x);
                        y = (int)Math.round(coo.y);
                        if (x >= 0 && x < pA.width && y >= 0 && y < pA.height) {
                            this.setPixRGB(this.pixelsRGB, i, tA, pARev ? 255 - pACm[0xFF & pA.pixels[y * pA.width + x]] : pACm[0xFF & pA.pixels[y * pA.width + x]]);
                        }
                    }
                }
                if (!pBeqRef && pB != null) {
                    pB.projd.getXY(coo);
                    if (!Double.isNaN(coo.x)) {
                        x = (int)Math.round(coo.x);
                        y = (int)Math.round(coo.y);
                        if (x >= 0 && x < pB.width && y >= 0 && y < pB.height) {
                            this.setPixRGB(this.pixelsRGB, i, tB, pBRev ? 255 - pBCm[0xFF & pB.pixels[y * pB.width + x]] : pBCm[0xFF & pB.pixels[y * pB.width + x]]);
                        }
                    }
                }
                if (i % 10000 != 0) continue;
                this.setPourcent((long)i * 100L / (long)this.pRef.pixels.length);
            }
        }
        this.setPourcent(-1.0);
        Aladin.trace(3, "Resampling achieved...");
        this.cm = ColorModel.getRGBdefault();
        this.bitpix = 8;
        boolean bl = this.twoColors = this.planRed == null || this.planGreen == null || this.planBlue == null;
        if (this.planRed == null) {
            this.createLastColor(this.pixelsRGB, 0);
        } else if (this.planGreen == null) {
            this.createLastColor(this.pixelsRGB, 1);
        } else if (this.planBlue == null) {
            this.createLastColor(this.pixelsRGB, 2);
        }
        this.calculPixelsZoomRGB();
        this.changeImgID();
        this.sendLog("RGB", " [R:" + this.labels[0] + ",G:" + this.labels[1] + ",B:" + this.labels[2] + "]");
        return true;
    }

    protected void createImgRGB() {
        this.createRGB();
        int size = this.width * this.height;
        this.pixelsRGB = new int[size];
        for (int y = 0; y < size; ++y) {
            this.pixelsRGB[y] = 0xFF000000 | (this.red[y] & 0xFF) << 16 | (this.green[y] & 0xFF) << 8 | this.blue[y] & 0xFF;
        }
        this.calculPixelsZoomRGB();
        this.changeImgID();
    }

    protected void createLastColor(int[] pixelsRGB, int color) {
        int k;
        int j;
        if (color == 0) {
            j = 1;
            k = 2;
        } else if (color == 1) {
            j = 0;
            k = 2;
        } else {
            j = 0;
            k = 1;
        }
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            int a1 = PlanImageRGB.getPixRGB(pixelsRGB, i, j);
            int b1 = PlanImageRGB.getPixRGB(pixelsRGB, i, k);
            if (this.diff) {
                if (a1 == b1) {
                    pixelsRGB[i] = -16777216;
                    continue;
                }
                if (a1 - b1 > 0) {
                    this.setPixRGB(pixelsRGB, i, j, a1 - b1);
                    this.setPixRGB(pixelsRGB, i, k, 0);
                    this.setPixRGB(pixelsRGB, i, color, 0);
                    continue;
                }
                this.setPixRGB(pixelsRGB, i, k, b1 - a1);
                this.setPixRGB(pixelsRGB, i, j, 0);
                this.setPixRGB(pixelsRGB, i, color, 0);
                continue;
            }
            this.setPixRGB(pixelsRGB, i, color, (a1 + b1) / 2);
        }
    }

    private void normalisation(byte[] a, byte[] b) {
        double c;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 2; ++i) {
            byte[] x = i == 0 ? a : b;
            for (int j = 0; j < x.length; ++j) {
                c = x[j] & 0xFF;
                if (c < min) {
                    min = c;
                }
                if (!(c > max)) continue;
                max = c;
            }
        }
        double r = 256.0 / (max - min);
        for (int i = 0; i < 2; ++i) {
            byte[] x = i == 0 ? a : b;
            for (int j = 0; j < x.length; ++j) {
                c = x[j] & 0xFF;
                x[j] = (byte)(c <= min ? 0 : (c >= max ? 255 : (int)((c - min) * r) & 0xFF));
            }
        }
    }

    protected void inverseRGB() {
        int size = this.width * this.height;
        for (int y = 0; y < size; ++y) {
            this.pixelsRGB[y] = this.pixelsRGB[y] ^ 0xFFFFFF;
        }
        this.changeImgID();
        this.aladin.calque.select.repaint();
    }

    public void filterRGB(int[] triangle, int color) {
        this.changeImgID();
        if (this.red == null) {
            this.createRGB();
        }
        int tr0 = triangle[0];
        int tr1 = triangle[1];
        int tr2 = triangle[2];
        int size = this.width * this.height;
        for (int pos = 0; pos < size; ++pos) {
            int r = (this.pixelsRGB[pos] & 0xFF0000) >> 16;
            int g = (this.pixelsRGB[pos] & 0xFF00) >> 8;
            int b = this.pixelsRGB[pos] & 0xFF;
            if (color == 0) {
                r = PlanImageRGB.filter(tr0, tr1, tr2, this.red[pos] & 0xFF);
            } else if (color == 1) {
                g = PlanImageRGB.filter(tr0, tr1, tr2, this.green[pos] & 0xFF);
            } else {
                b = PlanImageRGB.filter(tr0, tr1, tr2, this.blue[pos] & 0xFF);
            }
            if (this.video == 1) {
                if (color == 0) {
                    r ^= 0xFFFFFFFF;
                } else if (color == 1) {
                    g ^= 0xFFFFFFFF;
                } else {
                    b ^= 0xFFFFFFFF;
                }
                if (this.twoColors) {
                    if (!this.flagRed) {
                        r = Math.max(g & 0xFF, b & 0xFF);
                    } else if (!this.flagGreen) {
                        g = Math.max(r & 0xFF, b & 0xFF);
                    } else {
                        b = Math.max(r & 0xFF, g & 0xFF);
                    }
                }
            } else if (this.twoColors) {
                if (!this.flagRed) {
                    r = ((g & 0xFF) + (b & 0xFF)) / 2;
                } else if (!this.flagGreen) {
                    g = ((r & 0xFF) + (b & 0xFF)) / 2;
                } else {
                    b = ((r & 0xFF) + (g & 0xFF)) / 2;
                }
            }
            this.pixelsRGB[pos] = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }

    protected static final int filter(int tr0, int tr1, int tr2, int var) {
        double dy = 128.0;
        if (var <= tr0) {
            return 0;
        }
        if (var >= tr2) {
            return 255;
        }
        if (var > tr0 && var <= tr1) {
            double dx = tr1 - tr0;
            if (dx > 0.0) {
                double alpha = dy / dx;
                double beta = -alpha * (double)tr0;
                return (byte)((double)var * alpha + beta);
            }
        } else {
            double dx = tr2 - tr1;
            if (dx > 0.0) {
                double alpha = dy / dx;
                double beta = 128.0 - alpha * (double)tr1;
                return (byte)((double)var * alpha + beta);
            }
        }
        return var;
    }

    @Override
    protected void flip(int methode) throws Exception {
        this.createRGB();
        if (methode == 0 || methode == 2) {
            PlanImageRGB.invImageLine(this.width, this.height, this.pixelsRGB);
        }
        if (methode == 1 || methode == 2) {
            PlanImageRGB.invImageRow(this.width, this.height, this.pixelsRGB);
        }
        for (int i = 0; i < 3; ++i) {
            byte[] pixels;
            byte[] byArray = i == 0 ? this.red : (pixels = i == 1 ? this.green : this.blue);
            if (methode == 0 || methode == 2) {
                PlanImageRGB.invImageLine(this.width, this.height, pixels);
            }
            if (methode != 1 && methode != 2) continue;
            PlanImageRGB.invImageRow(this.width, this.height, pixels);
        }
        if (Projection.isOk(this.projd)) {
            this.projd.flip(methode);
        }
        this.changeImgID();
        this.calculPixelsZoomRGB();
        this.aladin.calque.zoom.zoomView.repaint();
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
    }

    protected static void invImageRow(int width, int height, int[] pixelsRGB) {
        for (int h = 0; h < height; ++h) {
            int offset1 = h * width;
            for (int w = width / 2 - 1; w >= 0; --w) {
                int offset2 = offset1 + width - w - 1;
                int tmp = pixelsRGB[offset1 + w];
                pixelsRGB[offset1 + w] = pixelsRGB[offset2];
                pixelsRGB[offset2] = tmp;
            }
        }
    }

    protected static void invImageLine(int width, int height, int[] pixelsRGB) {
        int[] tmp = new int[width];
        for (int h = height / 2 - 1; h >= 0; --h) {
            int offset1 = h * width;
            int offset2 = (height - h - 1) * width;
            System.arraycopy(pixelsRGB, offset1, tmp, 0, width);
            System.arraycopy(pixelsRGB, offset2, pixelsRGB, offset1, width);
            System.arraycopy(tmp, 0, pixelsRGB, offset2, width);
        }
    }

    @Override
    protected Image getImage(ViewSimple v, boolean now) {
        if (this.oImgID == this.imgID) {
            return this.image;
        }
        this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, this.cm, this.pixelsRGB, 0, this.width));
        this.oImgID = this.imgID;
        return this.image;
    }

    @Override
    public int getPixel8(int x, int y) {
        return this.pixelsRGB[y * this.width + x];
    }

    @Override
    protected byte getPixel8Byte(int x, int y) {
        return this.pixelsRGB == null ? (byte)0 : (byte)PlanImageRGB.getGreyPixel(this.getPixel8(x, y));
    }

    private void postAJLoad() {
        block8: {
            this.postAJDone = true;
            try {
                if (this.labelRed != null) {
                    this.planRed = (PlanImage)this.aladin.calque.getPlan(this.labelRed, 1);
                    boolean bl = this.flagRed = this.planRed != null;
                    if (this.flagRed) {
                        this.pi[0] = this.planRed.hashCode();
                    }
                }
                if (this.labelGreen != null) {
                    this.planGreen = (PlanImage)this.aladin.calque.getPlan(this.labelGreen, 1);
                    boolean bl = this.flagGreen = this.planGreen != null;
                    if (this.flagGreen) {
                        this.pi[1] = this.planGreen.hashCode();
                    }
                }
                if (this.labelBlue != null) {
                    this.planBlue = (PlanImage)this.aladin.calque.getPlan(this.labelBlue, 1);
                    boolean bl = this.flagBlue = this.planBlue != null;
                    if (this.flagBlue) {
                        this.pi[2] = this.planBlue.hashCode();
                    }
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block8;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected boolean hasOriginalPixels() {
        return true;
    }

    @Override
    protected String getPixelInfo(int x, int y, int mode) {
        if (!Projection.isOk(this.projd) || x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return "";
        }
        if (!this.postAJDone) {
            this.postAJLoad();
        }
        Coord c = new Coord();
        c.x = x;
        c.y = y;
        this.projd.getCoord(c);
        StringBuffer s1 = new StringBuffer();
        int n = 0;
        for (int j = 0; j < 3; ++j) {
            String s;
            PlanImage p;
            PlanImage planImage = j == 0 ? this.planRed : (p = j == 1 ? this.planGreen : this.planBlue);
            if (p == null || p.type == 0) {
                s = "";
            } else {
                p.projd.getXY(c);
                p.pixelsOriginFromCache();
                s = p.getPixelInfo((int)c.x, (int)c.y, mode);
                ++n;
            }
            if (s1.length() > 0) {
                s1.append(' ');
            }
            s1.append((j == 0 ? "R" : (j == 1 ? "G" : "B")) + ":" + Util.align(s, 6));
        }
        return n == 0 ? "" : s1.toString();
    }

    @Override
    protected void getPixels(byte[] newpixels, int x, int y, int w, int h) {
        int k = 0;
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        int n = y + h;
        for (int i = y; i < n; ++i) {
            int j = 0;
            while (j < w) {
                int c = this.pixelsRGB[i * this.width + x + j];
                newpixels[k] = (byte)(0xFF & ((c & 0xFF0000) >> 16 + (c & 0xFF00) >> 8 + (c & 0xFF)) / 3);
                ++j;
                ++k;
            }
        }
    }

    @Override
    protected void getPixels(double[] newpixels, int x, int y, int w, int h) {
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int c = this.pixelsRGB[(this.height - (i + y) - 1) * this.width + j + x];
                newpixels[i * w + j] = ((0xFF & c >> 24) + (0xFF & c >> 16) + (0xFF & c)) / 3;
            }
        }
    }

    @Override
    public void getPixels(int[] newpixels, int x, int y, int w, int h) {
        int k = 0;
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        int n = y + h;
        for (int i = y; i < n; ++i) {
            System.arraycopy(this.pixelsRGB, i * this.width + x, newpixels, k, w);
            k += w + aw;
        }
    }
}

